<?php
require_once "../Api.php";
require "./get/getTimeZones.php";
require "./put/updateTimeZones.php";
require "./post/createTimeZones.php";
require "./patch/changeTimeZones.php";
require "./delete/deleteTimeZones.php";

class timezonesApi extends Api
{
   public $apiName = "timezones";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/TimeZones
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "timezones":
               return getTimezones();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/TimeZones
    * @return string
    */
   public function createAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    firstConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/TimeZones
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "timezones":
               changeTimezones();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/TimeZones
    * @return string
    */
   public function updateAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    newConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/TimeZones
    * @return string
    */
   public function deleteAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    resetCamera($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }
}
